*Generate additional variables for the analysis

*Tim Goedemé

*2020


/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/


*/

global place1 A:\Stata files\Oxfiles\EU-SILC\Cross\2020-04\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK


*Active age and active labour market participation

foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2009(1)2010 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
			
			cap drop actage
			gen actage = ((year-rb080)>=18 & (year-rb080)<65)
			
			cap drop active
			
			if `year'<2009 gen active = (pl030<3)
			else gen active = (pl031<5)
		
			cap sum ok if year==`year' & actage==1 & (pl040==1 | pl040==2)
			if _rc==0 local val = r(mean)
			else local val=.

			keep country year hid pid actage active
			compress
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
		}

	}
}


*Age, equivalent disposable income and poverty status
******************************************************


cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2004(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
	
			cap drop age
			cap drop hydisp
			cap drop child14
			cap drop adult14
			cap drop hhnbr_child14
			cap drop hhnbr_adult14
			cap drop hhnbr_pers
			cap drop eqs
			cap drop sum080
			cap drop hystd
			cap drop thresh60
			cap drop arop60

			quietly {
				gen int age = rx020
				replace age = year-rb080 - 1 if rx020==.

				/*total disposable hh income * within hh non-response inflation factor*/ 

				*Since EU-SILC 2009, it is practice to include the sum of pensions received from individual private plans (other than
				*those covered under ESSPROS) (PY080G) into equivalent disposable income (HX090). However, for reasons of consistency over time: choose whether to include it or not
				*From EU-SILC 2011 onwards, PY080G is automatically included in the computation of HY020, so it is preferable to add it everywhere to make data comparable.


				* 'old' style:
				*gen hydisp=hy020*hy025 

				* 'new' style:
				cap gen hy025=1
				if `year'<2011 {
					bysort country hid: egen sum080=sum(py080g)
					gen hydisp=(hy020+sum080)*hy025
				}
				else gen hydisp=hy020*hy025

				gen byte child14=.
				replace child14=1 if age<14
				replace child14=0 if age>=14

				gen byte adult14=.
				replace adult14=1 if age>=14
				replace adult14=0 if age<14

				bysort country hid: egen hhnbr_child14 = sum(child14)
				bysort country hid: egen hhnbr_adult14 = sum(adult14)
				gen hhnbr_pers = hhnbr_child14 + hhnbr_adult14

				gen float eqs=.
				replace eqs= 1+(hhnbr_adult14 -1)*0.5 + hhnbr_child14 * 0.3 if hhnbr_adult14>=1
				replace eqs= 1+(hhnbr_child14 -1)* 0.3 if hhnbr_adult14<1

				gen hystd=hydisp/eqs

				gen thresh60=.
				qui: sum hystd [aw=rb050] if country=="`ctry'", de
				local v1 = 0.6*r(p50)
				replace thresh60=`v1' if country=="`ctry'"
				
				gen arop60=.
				replace arop60=1 if hystd<thresh60
				replace arop60=0 if hystd>=thresh60 & hystd!=.
				
				qui: sum arop60 [aw=rb050] if country=="`ctry'"
				local v2 = r(mean)
				
				keep country year hid pid age hydisp eqs hystd thresh60 arop60
				compress
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
				cap drop _merge
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
			}
		}
		mat def tempthresh = nullmat(tempthresh), `v1'
		mat def temppoors = nullmat(temppoors), `v2'
	}
	mat def thresholds = nullmat(thresholds) \ tempthresh
	mat def poors = nullmat(poors) \ temppoors
}

mat rownames thresholds = ${countries}
mat colnames thresholds = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 
mat rownames poors = ${countries}
mat colnames poors = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 

mat li thresholds
mat li poors

*Additional check

cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2004(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			quietly {
				use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
				merge 1:1 hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", keepusing(arop60)
				
				gen test = (hx080!=arop60)
				
				sum test [aw=rb050]
				local v1=r(mean)
			}
		}
		mat def temppoors = nullmat(temppoors), `v1'
		
	}
	mat def poors = nullmat(poors) \ temppoors
}
		
mat rownames poors = ${countries}
mat colnames poors = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 
mat li poors

***Income including production for own consumption (HY170N)
***********************************************************

global countries PL RO

cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2018(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
	
			cap drop age
			cap drop hydisp
			cap drop child14
			cap drop adult14
			cap drop hhnbr_child14
			cap drop hhnbr_adult14
			cap drop hhnbr_pers
			cap drop eqs
			cap drop sum080
			cap drop hystd
			cap drop thresh60
			cap drop arop60

			quietly {
				gen int age = rx020
				replace age = year-rb080 - 1 if rx020==.

				/*total disposable hh income * within hh non-response inflation factor*/ 

				*Since EU-SILC 2009, it is practice to include the sum of pensions received from individual private plans (other than
				*those covered under ESSPROS) (PY080G) into equivalent disposable income (HX090). However, for reasons of consistency over time: choose whether to include it or not
				*From EU-SILC 2011 onwards, PY080G is automatically included in the computation of HY020, so it is preferable to add it everywhere to make data comparable.


				* 'old' style:
				*gen hydisp=hy020*hy025 

				* 'new' style:
				cap gen hy025=1
				gen hydisp1=(hy020+hy170n)*hy025

				gen byte child14=.
				replace child14=1 if age<14
				replace child14=0 if age>=14

				gen byte adult14=.
				replace adult14=1 if age>=14
				replace adult14=0 if age<14

				bysort country hid: egen hhnbr_child14 = sum(child14)
				bysort country hid: egen hhnbr_adult14 = sum(adult14)
				gen hhnbr_pers = hhnbr_child14 + hhnbr_adult14

				gen float eqs=.
				replace eqs= 1+(hhnbr_adult14 -1)*0.5 + hhnbr_child14 * 0.3 if hhnbr_adult14>=1
				replace eqs= 1+(hhnbr_child14 -1)* 0.3 if hhnbr_adult14<1

				gen hystd1=hydisp1/eqs

				gen thresh601=.
				qui: sum hystd1 [aw=rb050] if country=="`ctry'", de
				local v1 = 0.6*r(p50)
				replace thresh601=`v1' if country=="`ctry'"
				
				gen arop601=.
				replace arop601=1 if hystd1<thresh601
				replace arop601=0 if hystd1>=thresh601 & hystd!=.
				
				qui: sum arop601 [aw=rb050] if country=="`ctry'"
				local v2 = r(mean)
				
				keep country year hid pid age hydisp eqs hystd thresh60 arop60
				compress
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
				cap drop _merge
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
			}
		}
		mat def tempthresh = nullmat(tempthresh), `v1'
		mat def temppoors = nullmat(temppoors), `v2'
	}
	mat def thresholds = nullmat(thresholds) \ tempthresh
	mat def poors = nullmat(poors) \ temppoors
}

mat rownames thresholds = ${countries}
mat colnames thresholds = 2018 
mat rownames poors = ${countries}
mat colnames poors = 2018 

mat li thresholds
mat li poors



***Earnings***
**************


foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2018(1)2018 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
			
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			
			sum py020g [iw=pb040] if active==1 & actage==1 & py020g>0 & py020g!=. // with exception of AT, all countries have values
			local top = r(p99)
			cap drop compcar
			gen compcar = py020g
			replace compcar = `top' if py020g>`top' & py020g!=.
			replace compcar = 0 if py020g<0 | py020g==. | country=="AT" | country=="FR"
			
			
			cap drop earns1 
			gen earns1 = py010g + py050g
			replace earns1 = 0 if earns1<0
			cap _pctile earns1 [pw=pb040] if actage==1 & active==1 & earns1!=0, p(50 99.9)
			local med=r(r1)
			local top=r(r2)
			replace earns1 = `top' if earns1>`top' & earns1!=.
			replace earns1 = earns1 / `med'
			
			cap drop earns2 
			gen earns2 = py010g + compcar + py050g
			replace earns2 = 0 if earns2<0
			cap _pctile earns2 [pw=pb040] if actage==1 & active==1 & earns2!=0, p(50 99.9)
			local med=r(r1)
			local top=r(r2)
			replace earns2 = `top' if earns2>`top' & earns2!=.
			replace earns2 = earns2 / `med'
			
			sum earns1 earns2 [aw=pb040] if active==1 & actage==1 & earns1!=0, de
			
			keep country year hid pid earns1 earns2
			compress
			
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			cap drop _merge
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
		}

	}
}

* other covariates * 
********************

cap mat drop results1
cap mat drop results2

foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2018(1)2018 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
			cap drop _merge
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			cap drop _merge
			*1. full-year, full-time equivalent number of hours
			****************************************************
			local vars pl073 pl074 pl075 pl076
			foreach var of local vars {
				cap drop `var'b
				gen `var'b = `var'
				replace `var'b=0 if `var'==.
			}
			
			cap drop testje
			gen testje = pl073+pl075

			cap drop fyft
			gen fyft = 1 if pl073==12
			replace fyft = 1 if pl075==12
			replace fyft = 1 if testje==12
			replace fyft = . if pl073==. & pl075==. 

			cap drop hours
			gen hours = pl060
			replace hours = pl060 + pl100 if pl100!=.

			qui: sum hours [aw=pb040] if active==1 & actage==1 & earns2!=. & pl040==3 & fyft==1, de
			local med=r(p50)
			cap drop shours
			gen shours = hours/`med'

			cap drop fyfte
			gen fyfte = (pl073b + pl075b + min(1, shours)*(pl074b + pl076b))/12
			replace fyfte = 1 if fyft==1
			replace fyfte = . if pl073==. & pl075==.
			
			*2. gender
			cap drop sex
			gen sex = (rb090==2) // in new variable 1==female, 0==male

			***immigration and citizenship
			cap drop immigrant
			gen immigrant = 0 if pb210=="LOC"
			replace immigrant = 1 if pb210=="EU" | pb210=="OTH"
						

			***level of education
			cap drop education
			gen education = pe040
			replace education = 200 if education <200
			replace education = 300 if pe040>=300 & pe040<500
			replace education = 500 if pe040>=500 & pe040!=.
			
			***health and disability
			cap drop disabled
			gen disabled = (py130g>0) if py130g!=.
			replace disabled = 0 if py130n==0 & py130g==.
			replace disabled = 1 if py130n>0 & py130g==. & py130n!=.

			cap drop health
			gen health = (ph030<3)
			

			
			*b. Labour market participation
			********************************

			***economic sector: pl111 (unaltered)
			cap drop sector
			encode pl111, gen(sector)

			***Type of contract
			cap drop temporary
			gen temporary = 0 // also self-employed and missing values  = 0
			replace temporary = 1 if pl140==2


			***career

			cap drop career
			gen career=age-pl190 if age-pl190>=0
			replace career = pl200 if (age-pl190)<0 & (age-pl200)>=8 & pl200!=. // 8 is also taken to be the minimum age for PL190
			

			*c. Household composition
			**************************
			
			cap drop person
			gen person=1
			cap drop npers
			bysort hid: egen npers = sum(person)
			
			cap drop child
			gen child = (age<18)
			cap drop nchilds
			bysort hid: egen nchilds = sum(child)
			
			cap drop depadult
			gen depadult = 1 if child==0 & earns1<0.05 & npers>1 & npers!=.
			cap drop ndepadults
			bysort hid: egen ndepadults = sum(depadult)
			
			cap drop adult
			gen adult = (child!=1 & depadult!=1)
			cap drop nadults
			bysort hid: egen nadults = sum(adult)
			
			***household types // adult children who are still in education are considert dependent adults, rather than dependent children...

			cap drop single
			gen single = (npers==1)

			cap drop oneearner
			gen oneearner = (nadults==1 & nchilds==0 & ndepadults>0)

			cap drop singleparent
			gen singleparent = (nadults==1 & nchilds>0 & ndepadults==0 | nadults==0 & nchilds>0 & ndepadults==1)

			cap drop breadwinner 
			gen breadwinner = (nadults==1 & nchilds>0 & ndepadults>0)

			cap drop othernochild
			gen othernochild = (nadults>1 & nchilds==0)

			cap drop otherwchild
			gen otherwchild = (nadults>1 & nchilds>0)

			*d. Technical variables
			***********************
			global persvars age sex immigrant disabled health
			global skills education
			global lbmvars sector fyfte temporary career
			global hhvars single oneearner singleparent breadwinner othernochild otherwchild
			global allvars ${persvars} ${skills} ${lbmvars} ${hhvars}

			cap drop misvars
			egen misvars = rowmiss(${allvars})
			
			cap drop missers
			gen missers = misvars>0
			
			gen sub = (active==1 & actage==1 & rb245!=3) // rb245==3 indicates 'non-selected respondent' in selected respondent countries
			
			cap drop weight
			gen weight=pb040
			replace weight = pb060 if pb060!=.
			
			
			*e. Explore missing values
			**************************
			
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta", keepusing(esec08)
			
			cap mat drop tempmat1
			cap mat drop tempmat2
			forvalues c=1/9 {
				count if esec08==`c'
				if r(N)>0 {
					sum missers if sub==1 & esec08==`c' & earns1>0 & earns1!=.
					local val1=r(mean)
					sum missers [iw=weigh] if sub==1 & esec08==`c' & earns1>0 & earns1!=.
					local val2=r(mean)
				}
				else {
					local val1=.
					local val2=.
				}
			mat def tempmat1 =  nullmat(tempmat1), `val1'
			mat def tempmat2 =  nullmat(tempmat2), `val2'
			}
			
			mat def results1 = nullmat(results1) \ tempmat1
			mat def results2 = nullmat(results2) \ tempmat2


			*Save variables

			keep country year hid pid esec08 fyfte sex immigrant education disabled health sector temporary career single oneearner singleparent breadwinner othernochild otherwchild nchilds nadults ndepadults sub missers weight psu1 strata1
			compress
			
			cap drop _merge
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			cap drop _merge
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", replace
		}
		
		else {
			mat def tempmat1 =  100, 100, 100, 100, 100, 100, 100, 100, 100
			mat def tempmat2 =  100, 100, 100, 100, 100, 100, 100, 100, 100
						
			mat def results1 = nullmat(results1) \ tempmat1
			mat def results2 = nullmat(results2) \ tempmat2
		
		}

	}
}

mat rownames results1 = ${countries}
mat rownames results2 = ${countries}

mat colnames results1 = 1 2 3 4 5 6 7 8 9
mat colnames results2 = 1 2 3 4 5 6 7 8 9

di "proportion missing cases by social class: unweighted"
mat li results1

di "proportion missing cases by social class: weighted"
mat li results2



* Other covariates: redefine missing variables/cases *
******************************************************

*To enable a counterfactual estimate of purely compositional effects, interaction terms should be estimated for each social class and all ///
* variables in the regression model. This is only possible if there exists at least one observation for each combination of social class and each category of the variable of interest
* ===> only variables / social classes can be included that are in accordance with this need

* an analysis of which variable/social class combinations are problematic, is carried out with do-file "11_Explore missing values.do"

* A variable such as economic sector of economic activity and temporary work do not comply with this definition, partially because some occupations/classes simply do not occur in some sectors or only consist of self-employed
* with a 9-class model, this provides also a substantial reason to exclude economic sector and temporary employment (number of hours worked paritally capture temporary employment anyway).
* Furthermore the 'disabled' variable has relatively many social classes without any disabled person
* In addition, we included continuous variables related to household composition, as the likelihood of finding 'empty cells' or cells consisting of a constant was also much smaller

* Other adjustments vary by country:
*** social classes that account for less than 1.5% of people in paid employment are excluded ('Small farmers' in many countries as well as the Petit Bourgeois in DK and Higher Blue collar workers in RO.
*** In countries with relatively few immigrants in the workforce (BG, HU, PL and RO), this variable was excluded as well
*** In SI the High salariat does not have any low educated. As a solution, we included education as a continous variable
 
 *We leave out IS and SK as PL051 not available
 global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK
			
cap mat drop results1
cap mat drop results2

foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2018(1)2018 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
			
			*redefine missers variable
			**************************
			
			gen init = sub
			
			
			gen class=esec08
			
			if regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 replace class = . if esec08==5 // (class 5 accounts for less than 1.5% of population in paid employment)
			if regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 replace init = 0 if esec08==5 
			
			if "`ctry'"=="DK" replace class = . if (esec08==5 | esec08==4)
			if "`ctry'"=="DK" replace init = 0 if (esec08==5 | esec08==4)
			
			if "`ctry'"=="RO" replace class = . if (esec08==6)
			if "`ctry'"=="RO" replace init = 0 if (esec08==6)
			
			if regexm("BG HU PL RO", "`ctry'")==1 global allvars fyfte sex education health career nchilds nadults ndepadults
			else global allvars fyfte sex immigrant education health career nchilds nadults ndepadults
			
			cap drop misvars2
			egen misvars2 = rowmiss(${allvars})
			
			cap drop missers2
			gen missers2 = misvars2>0
			
		
			*e. Explore missing values
			**************************
			svyset psu1 [pw=weight], strata(strata1)
			subprop3 class, subpop(sub) na(test)
			local rows=rowsof(test)
			local classes
			forvalues x=1/`rows' {
				local c=el(test, `x', 1)
				local classes `classes' `c'
			}
			
			cap mat drop tempmat1
			cap mat drop tempmat2
			forvalues c=1/9 {
				count if esec08==`c'
				if r(N)>0 {
					sum missers2 if init==1 & esec08==`c' & earns1>0 & earns1!=.
					local val1=r(mean)
					sum missers2 [iw=weigh] if init==1 & esec08==`c' & earns1>0 & earns1!=.
					local val2=r(mean)
					if (regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 & `c'==5) | ("`ctry'"=="DK" & `c'==4) | ("`ctry'"=="RO" & `c'==6) {
						local val1=500
						local val2=500
					}
				}
				else {
					local val1=.
					local val2=.
				}
			mat def tempmat1 =  nullmat(tempmat1), `val1'
			mat def tempmat2 =  nullmat(tempmat2), `val2'
			}
			
			sum missers2 if init==1 & esec08!=. & earns1>0 & earns1!=.
			local val1=r(mean)
			sum missers2 [iw=weigh] if init==1 & esec08!=. & earns1>0 & earns1!=.
			local val2=r(mean)
			
			mat def tempmat1 =  nullmat(tempmat1), `val1'
			mat def tempmat2 =  nullmat(tempmat2), `val2'
			
			mat def results1 = nullmat(results1) \ tempmat1
			mat def results2 = nullmat(results2) \ tempmat2


			*Save variables

			keep country year hid pid esec08 fyfte sex immigrant education health career nchilds nadults ndepadults sub weight psu1 strata1 missers2
			compress
			
			cap drop _merge
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			cap drop _merge
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", replace
		}
		
		else {
			mat def tempmat1 =  100, 100, 100, 100, 100, 100, 100, 100, 100
			mat def tempmat2 =  100, 100, 100, 100, 100, 100, 100, 100, 100
						
			mat def results1 = nullmat(results1) \ tempmat1
			mat def results2 = nullmat(results2) \ tempmat2
		
		}

	}
}

mat rownames results1 = ${countries}
mat rownames results2 = ${countries}

mat colnames results1 = 1 2 3 4 5 6 7 8 9 total
mat colnames results2 = 1 2 3 4 5 6 7 8 9 total

di "proportion missing cases by social class: unweighted"
mat li results1

di "proportion missing cases by social class: weighted"
mat li results2

